/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#include <linux/wait.h>


#define CPCL_VERSION_MAJOR      1
#define CPCL_VERSION_MINOR      0
#define CPCL_VERSION_REVISION   0

#define CPCL_MAJOR         147     
#define CPCL_NR_DEVS       1       

#define CPCL_IOC_MAGIC		0x53

#define CPCL_IOC_INIT			_IOR(CPCL_IOC_MAGIC, 0x01, cpcl_arg_init_t)
#define CPCL_IOC_TERM			_IOR(CPCL_IOC_MAGIC, 0x02, cpcl_arg_term_t)

#define CPCL_IOC_ALLOC_KEYPORT		_IOR(CPCL_IOC_MAGIC, 0x08, cpcl_arg_alloc_keyport_t)
#define CPCL_IOC_FREE_KEYPORT		_IOR(CPCL_IOC_MAGIC, 0x09, cpcl_arg_free_keyport_t)

#define CPCL_IOC_ASSIGN_BUF_DMA		_IOR(CPCL_IOC_MAGIC, 0x0B, cpcl_arg_assign_buf_dma_t)
#define CPCL_IOC_RELEASE_BUF_DMA	_IOR(CPCL_IOC_MAGIC, 0x0C, cpcl_arg_release_buf_dma_t)
#define CPCL_IOC_SET_DMAPTR		_IOR(CPCL_IOC_MAGIC, 0x0D, cpcl_arg_set_dmaptr_t)
#define CPCL_IOC_START_DMA		_IOR(CPCL_IOC_MAGIC, 0x0E, cpcl_arg_start_dma_t)
#define CPCL_IOC_STOP_DMA		_IOR(CPCL_IOC_MAGIC, 0x0F, cpcl_arg_stop_dma_t)
#define CPCL_IOC_RESET_DMA		_IOR(CPCL_IOC_MAGIC, 0x10, cpcl_arg_reset_dma_t)
#define CPCL_IOC_REGISTER_DMANOTIFY	_IOR(CPCL_IOC_MAGIC, 0x11, cpcl_arg_register_dmanotify_t)
#define CPCL_IOC_UNREGISTER_DMANOTIFY	_IOR(CPCL_IOC_MAGIC, 0x12, cpcl_arg_unregister_dmanotify_t)
#define CPCL_IOC_SET_DMA_EVENTMASK	_IOR(CPCL_IOC_MAGIC, 0x13, cpcl_arg_set_dma_eventmask_t)
#define CPCL_IOC_GET_DMAINFO		_IOR(CPCL_IOC_MAGIC, 0x15, cpcl_arg_get_dmainfo_t)

#define CPCL_IOC_LOCAL_AUTH			_IOR(CPCL_IOC_MAGIC, 0x16, cpcl_arg_local_auth_t)
#define CPCL_IOC_LOCAL_MAKE_RECSEED	_IOR(CPCL_IOC_MAGIC, 0x19, cpcl_arg_local_make_recseed_t)
#define CPCL_IOC_LOCAL_MAKE_RECKEY	_IOR(CPCL_IOC_MAGIC, 0x1A, cpcl_arg_local_make_reckey_t)
#define CPCL_IOC_LOCAL_SET_MODE		_IOR(CPCL_IOC_MAGIC, 0x1B, cpcl_arg_local_set_mode_t)
#define CPCL_IOC_THROUGH_SET_MODE	_IOR(CPCL_IOC_MAGIC, 0x1C, cpcl_arg_through_set_mode_t)
typedef struct _cpcl_arg_init_t {
    INT32		status;
} cpcl_arg_init_t;

typedef struct _cpcl_arg_term_t {
    INT32		status;
} cpcl_arg_term_t;

typedef struct _cpcl_arg_alloc_keyport_t {
    INT32		status;
    UINT32*		key_id;
} cpcl_arg_alloc_keyport_t;

typedef struct _cpcl_arg_free_keyport_t {
    INT32		status;
    UINT32		key_id;
} cpcl_arg_free_keyport_t;

typedef struct _cpcl_arg_assign_buf_dma_t {
    INT32		status;
    UINT32		key_id;
    UINT8		dir;
    UINT32		buf_id;
    UINT8		loop;
} cpcl_arg_assign_buf_dma_t;

typedef struct _cpcl_arg_release_buf_dma_t {
    INT32		status;
    UINT32		key_id;
    UINT8		dir;
} cpcl_arg_release_buf_dma_t;

typedef struct _cpcl_arg_set_dmaptr_t {
    INT32               status;
    UINT32              key_id;
    UINT8               dir;
    UINT8               type;
    UINT32              offset;
} cpcl_arg_set_dmaptr_t;

typedef struct _cpcl_arg_start_dma_t {
    INT32		status;
    UINT32		key_id;
    UINT8		dir;
    UINT32		size;
    UINT32		offset;
    UINT8		api_sync;
    UINT8		sync_ptr;
} cpcl_arg_start_dma_t;

typedef struct _cpcl_arg_stop_dma_t {
    INT32               status;
    UINT32              key_id;
    UINT8               dir;
} cpcl_arg_stop_dma_t;

typedef struct _cpcl_arg_reset_dma_t {
    INT32               status;
    UINT32              key_id;
    UINT8               dir;
} cpcl_arg_reset_dma_t;

typedef struct _cpcl_arg_register_dmanotify_t {
    INT32		status;
    UINT32		key_id;
    UINT8		dir;
} cpcl_arg_register_dmanotify_t;

typedef struct _cpcl_arg_unregister_dmanotify_t {
    INT32		status;
    UINT32		key_id;
    UINT8		dir;
} cpcl_arg_unregister_dmanotify_t;

typedef struct _cpcl_arg_set_dma_eventmask_t {
    INT32		status;
    UINT32		key_id;
    UINT8		dir;
    UINT32		mask;
} cpcl_arg_set_dma_eventmask_t;

typedef struct _cpcl_arg_get_dmainfo_t {
    INT32		status;
    UINT32		key_id;
    UINT8		dir;
    UINT8		state;
    UINT32		buf_id;
    UINT32		write_ptr;
    UINT32		read_ptr;
    UINT32		size;
} cpcl_arg_get_dmainfo_t;
typedef struct _cpcl_arg_local_auth_t {
    INT32               status;
    UINT32              key_id;
    UINT8               *devicekey;
} cpcl_arg_local_auth_t;

typedef struct _cpcl_arg_local_make_recseed_t {
    INT32               status;
    UINT32              key_id;
    UINT8               *rec_seed;
} cpcl_arg_local_make_recseed_t;

typedef struct _cpcl_arg_local_make_reckey_t {
    INT32               status;
    UINT32              key_id;
    UINT8               *rec_seed;
} cpcl_arg_local_make_reckey_t;

typedef struct _cpcl_arg_local_set_mode_t {
    INT32               status;
    UINT32              key_id;
    UINT8               mode;
    UINT8               algo;
    UINT8               blk_mode;
    UINT8               init;
    UINT32              header;
    UINT32              payload;
    UINT32              footer;
} cpcl_arg_local_set_mode_t;

typedef struct _cpcl_arg_through_set_mode_t {
    INT32               status;
    UINT32              key_id;
} cpcl_arg_through_set_mode_t;
typedef struct  _cpcl_ioctl_t {
    union {
	cpcl_arg_init_t                 init;
	cpcl_arg_term_t                 term;
	cpcl_arg_alloc_keyport_t        alloc_keyport;
	cpcl_arg_free_keyport_t         free_keyport;
	cpcl_arg_assign_buf_dma_t       assign_buf_dma;
	cpcl_arg_release_buf_dma_t      release_buf_dma;
	cpcl_arg_set_dmaptr_t           set_dmaptr;
	cpcl_arg_start_dma_t            start_dma;
	cpcl_arg_stop_dma_t             stop_dma;
	cpcl_arg_reset_dma_t            reset_dma;
	cpcl_arg_register_dmanotify_t   register_dmanotify;
	cpcl_arg_unregister_dmanotify_t unregister_dmanotify;
	cpcl_arg_set_dma_eventmask_t    set_dma_eventmask;
	cpcl_arg_get_dmainfo_t          get_dmainfo;
	cpcl_arg_local_auth_t local_auth;
	cpcl_arg_local_make_recseed_t local_make_recseed;
	cpcl_arg_local_make_reckey_t local_make_reckey;
	cpcl_arg_local_set_mode_t local_set_mode;
	cpcl_arg_through_set_mode_t through_set_mode;
    } ioctl;
} cpcl_ioctl_t;

typedef struct _cpcl_dma_notify_info_t {
    UINT32 key_id;
    UINT8 dir;
    UINT32 event;
} cpcl_dma_notify_info_t;
